// 请勿修改此文件
import React, { useEffect, useReducer } from "react";
import createHistory from "history/createHashHistory";
import reducer, { initialState } from './reducers/global';
/*
 全局导入less
 */
import "./app.css";
import { getGlobalData, WECODE_DATA_TYPE } from "./actions/global";
import routes from "./routes";
import AppDispatch from './AppDispatch';

const { Route, Router } = require("react-router-dom");
const history = createHistory();


export default function App() {
  const [state, dispatch] = useReducer(reducer, initialState);
  // Similar to componentDidMount and componentDidUpdate:
  useEffect(() => {
    // prevent setting state for unmounted components.
    let ignore = false;
    getGlobalData().then((payload)=> {
      if (!ignore) {
        dispatch({ type: WECODE_DATA_TYPE, payload});
      }
    });

    // console.log("监听页面返回事件");
    const backFunction = () => {
      // 监听页面返回事件，return true直接返回，return false，拒绝返回。只支持安卓
      const flag = true;
      return flag;
    }
    window.HWH5.addEventListener({
      type: "back",
      func: backFunction
    });

    return ()=> {
      // 组件销毁事件
      ignore = true;
      window.HWH5.removeEventListener({ type: 'back', func: backFunction });
    };
  }, []);
  if (state === null) {
    return null;
  }
  // global state 有数据时再渲染
  return (
    <AppDispatch.Provider value={[state, dispatch]}>
      <Router history={history}>
        <Route
          render={() =>
            routes.map(route => {
              const { path, location, exact = true, component: C } = route;
              return (
                <Route
                  key={path}
                  location={location}
                  path={path}
                  exact={exact}
                  component={_props => (
                    <C {..._props} {...state} />
                  )}
                />
              );
            })
          }
        />
      </Router>
    </AppDispatch.Provider>
  );
}
