import React, { useEffect, useReducer, useContext } from 'react';
import PropTypes from 'prop-types';
import {
  ExceptionTip
} from '@wecode/react-weui';
import i18n from 'i18n';
import { Link } from 'react-router-dom';
import * as css from './index.module.css';
import { GLOBAL_EXAMPLE_DATA } from '../../actions/global';
import { fetchDataDemoAction, FETCH_DEMO_INIT, FETCH_DEMO_SUCCESS, FETCH_DEMO_FAILURE } from '../../actions/home';
import homeReducer, { initialState } from '../../reducers/home';
import AppDispatch from '../../AppDispatch';

export default function Home() {
  // 设置导航标题
  HWH5.navTitle({ title: 'Hello World' });

  // 如果我们想要执行一个 action，我们可以从 context 中获取 dispatch。
  const appDispatch = useContext(AppDispatch)[1];
   // 执行全局的action，可改变全局的state，将会重渲染页面。
  function handleClick() {
    appDispatch({ type: GLOBAL_EXAMPLE_DATA, payload: 'hello' });
  }

  const [state, dispatch] = useReducer(homeReducer, initialState);
  const { isLoading, isError } = state;
  if(isLoading) {
    HWH5.showLoading();
  } else {
    HWH5.hideLoading();
  }

  console.log(state, '--- home state');
  useEffect(() => {
    // prevent setting state for unmounted components.
    let ignore = false;
    dispatch({ type: FETCH_DEMO_INIT });
    fetchDataDemoAction().then((payload)=> {
      if (!ignore) {
        dispatch({ type: FETCH_DEMO_SUCCESS, payload });
      }
    }).catch((error)=> {
      dispatch({ type: FETCH_DEMO_FAILURE });
      console.log('Error:', error);
    });
    return () => {
      // 销毁事件
      HWH5.navTitle({ title: '' });
      ignore = true;
    }
  }, []);

  return (
    <div className={css.App}>
      {isError &&
        <ExceptionTip
          flag={1}
          msg={'请求数据异常！'}
          submsg={'请重试'}
        /> }
      <div className={css['App-header']} />
      <h1 className={css['App-title']}>{i18n.t('common:welcome')}</h1>
      <p className={css['App-intro']} onClick={() => handleClick()}>
        {i18n.t('home:getStart')} {i18n.t('home:edit')}
        <code>src/routes/Home/index.js</code> {i18n.t('home:saveReload')}
      </p>
      <Link to='/desc' className={css['home-link']}>
        使用说明
        </Link>
      <Link to='/navigateto' className={css['home-link']}>
        页面跳转示例
        </Link>
      <Link to='/refresh' className={css['home-link']}>
        下拉刷新示例
      </Link>
    </div>
  );
}

Home.propTypes = {
  homeInfo: PropTypes.object,
  dataList: PropTypes.array,
  getHomeInfo: PropTypes.func,
  getFetchDemo: PropTypes.func
};
