import React from "react";
import { Button } from '@wecode/react-weui';

export default function NavigateTo(props) {
    HWH5.navTitle({ title: "跳转示例" });

    function navigaetTo() {
        // 路由组件的 props 中，默认有 history 对象。其他组件想使用，可通过以下方法进行获取：
        // import createHistory from "history/createHashHistory";
        // const history = createHistory();
        const { history } = props;
        // 跳转内部页面并传值
        history.push({
            pathname: '/navigateto/page',
            customData: { test: '测试数据' } // customData 为自定义 key 值，接受的时候匹配上即可。如：const { customData } = location;
        })
    }

    return (
        <React.Fragment>
            <Button type="warn" size="middle" onClick={()=> navigaetTo()}>
              内部跳转
            </Button>
            <Button type="primary" size="middle" onClick={()=> {
                HWH5.openWebview({
                  uri: 'https://www.baidu.com'
                });
            }}>
              外部跳转
            </Button>
        </React.Fragment>
    )
}