﻿# 物品领用 app

## 项目背景
通过We码实现公司内部物品领用场景，以求解决公司之前物品领用缓慢，物品、领用人混淆等问题

操作流程：
1. 物品领用 We码 首页 显示 “我的申请”、“我的审批” 两个标签栏，并且有全部、已通过、审批中、已驳回、已审批、审批中状态
2. “我的申请” 顾名思义就是个人发起的物品领用申请，通过“新建”按钮发起申请，填好对应物品明细信息及审批人之后提交，等待上级审批。在此期间可以通过 全部、已通过、审批中、已驳回四个状态查看自己的申请记录，及时做好下一步准备。
3. “我的审批” 则是个人收到的下级物品领用申请，点击一项审批记录进入记录详情查看物品申请明细，按钮“通过”、“驳回”两个状态审批此条物品申请。通过全部、已审批、审批中三个状态查看自己审批记录。

## 项目结构
```
├─.babelrc                      // es6 转码和插件配置文件
├─.editorconfig                 // 编辑器配置文件
├─.eslintignore
├─.eslintrc                     // eslint 代码检查配置
├─.gitignore
├─.stylelintrc                  // css 语法检测配置
├─jsconfig.json
├─package.json                  // node 相关环境的配置文件
├─plugin.json                   // 服务器 环境配置文件
├─postcss.config.js             // css 插件 postcss 配置文件
├─README.md                     // 项目描述文件
├─server.config.js              // 服务器 端口配置文件
├─webpack.config.js             // webpack 配置文件
├─__test__                      // jest 测试集
|    └name.test.js
├─src                           // App 代码
|  ├─App.js                     //    App 项目组件容器
|  ├─app.less                   //    App 全局样式
|  ├─entry.js                   //    App 入口，项目框架容器
|  ├─i18n.js                    //    App 国际语言插件
|  ├─index.html                 //    App Html 模板
|  ├─utils                      //    App 插件
|  |   ├─const.js               //        pp 公共常量、方法
|  |   ├─cookie.js              //        cookie 插件
|  |   ├─getLang.js             //        获取 App 当前语言
|  |   ├─isiOS.js               //        判断是否 IOS 设备
|  |   └isProd.js               //        判断是否生产环境
|  ├─routes                     //    App 模块
|  |   ├─index.js               //        模块入口，App 路由配置
|  |   ├─Home                   //        物品领用 首页 列表
|  |   |  ├─index.js            //            Home 模块
|  |   |  ├─index.less          //            Home 模块样式
|  |   |  ├─package.json        //            模块配置文件
|  |   |  ├─pull.less           //            react-pullload 插件样式
|  |   |  ├─images              //            Home 模块下图片
|  |   |  |   ├─blueRadio.png   
|  |   |  |   └blueTop.png
|  |   ├─Detail                 //        物品领用 详情模块
|  |   |   ├─index.js           //            Detail 模块
|  |   |   └index.less          //            Detail 模块样式
|  |   ├─Apply                  //        物品领用 申请模块
|  |   |   ├─index.js           //            Apply 模块
|  |   |   ├─index.less         //            Apply 模块样式
|  |   |   ├─package.json       //            模块配置文件
|  |   |   ├─images             //            Apply 模块下图片
|  ├─reducers                   //    App state 仓库
|  |    ├─apply.js              //        申请模块
|  |    ├─detail.js             //        详情模块
|  |    ├─global.js             //        公共
|  |    ├─home.js               //        首页模块
|  |    └index.js               //        reducers 入口
|  ├─locales                    //    App 国际语言
|  |    ├─index.js              //        入口
|  |    ├─zh_CN                 //        中文模块
|  |    |   ├─common.json       //            App 公共语言
|  |    |   └home.json          //            App 首页语言
|  |    ├─en_US                 //        英文模块
|  |    |   ├─common.json       //            App 公共语言
|  |    |   └home.json          //            App 首页语言
|  ├─dummy                      //    App 模拟数据
|  |   ├─addList.json           //        新增物品申请 数据
|  |   ├─applyList.json         //        我的申请列表 数据
|  |   ├─approveList.json       //        我的审批列表 数据
|  |   └detailList.json         //        物品领用详情 数据
|  ├─config                     //    App 接口地址配置，可生产、uat 和开发环境配置
|  |   └web.config.js
|  ├─components                 //    App 组件
|  |     ├─Page                 //        页面布局组件
|  |     |  ├─index.js          //            组件 js
|  |     |  ├─index.less        //            组件样式
|  |     |  └package.json       //            组件配置文件
|  |     ├─ListBox              //        首页，列表项组件
|  |     |    ├─index.js        //            组件 js
|  |     |    ├─index.less      //            组件样式
|  |     |    └package.json     //            组件配置文件
|  |     ├─IconBox              //        图标容器组件
|  |     |    ├─index.js
|  |     |    ├─index.less
|  |     |    └package.json
|  |     ├─Header               //        页面头部组件
|  |     |   ├─index.js
|  |     |   ├─index.less
|  |     |   ├─package.json
|  |     |   ├─images           //            组件下图片
|  |     |   |   └back.png
|  |     ├─ExceptionTip         //        首页，数据缺省组件
|  |     |      ├─index.js
|  |     |      └index.less
|  |     ├─Article              //        申请模块 物品详细输入框组件
|  |     |    ├─index.js
|  |     |    ├─index.less
|  |     |    └package.json
|  ├─actions                    //    App 请求处理
|  |    ├─apply.js              //        申请模块
|  |    ├─detail.js             //        详情模块
|  |    ├─global.js             //        公共
|  |    └home.js                //        首页列表模块
├─public                        //    App 外部资源存放文件夹
|   ├─js
|   | └inobounce.js
├─build                         //    App 打包后输入文件存放地方
├─.vscode
|    └settings.json
```

## 其他
1. 本项目仅包含前端交互逻辑，不涉及后台交互，数据存在./src/dummy中。项目代码仅供参考。
2. We码基础入门还请参考：[We码是什么](https://cloudlinkworkplace.huaweicloud.com/wecode/docs/desc/quickstart/index_cloud.html)