/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 10:22:31
* @project : We码 物品领用
* @description : 项目组件容器
*
* @last modified by : jiys
* @last modified time : 2018-12-12 10:22:31
*
*/

import React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Route from 'react-router-dom/Route';
import Router from 'react-router-dom/Router';
import createHistory from 'history/createHashHistory';
const history = createHistory();

/*
 全局导入less
 */
import './app.less';
import * as global from 'actions/global';

import routes from './routes';

@connect(
  state => ({ ...state.global }),
  dispatch => bindActionCreators(global, dispatch)
)
export default class App extends React.Component {

  componentDidMount() {
    window.addEventListener('hashchange', () => {
    });
    window.HWH5.addEventListener({
      type: 'back',
      func: () => {
        // 监听页面返回事件，return true直接返回，return false，拒绝返回。只支持安卓
        const flag = true;
        return flag;
      }
    }).catch((error) => {
      console.log('监听事件发生异常', error);
    });
  }

  render() {
    return (
      <div className="appContainer">
        <Router history={history}>
          <Route render={({ location }) => {
            {
              return routes.map(route => (
                <Route
                  key={route.path}
                  location={location}
                  path={route.path}
                  exact={route.exact}
                  component={route.component}
                />
              ));
            }
          }
          }
          />
        </Router>
      </div>
    );
  }
};
