/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:35:07
* @project : We码 物品领用
* @description : 物品申请页面 apply action
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:35:07
*
*/

import i18n from 'i18n';
import { urls } from '../config/web.config';

export const _initStateData = () => (dispatch) => {
  dispatch({ type: 'initStateData' });
};

export const setClaimInfo = (key, value) => (dispatch, getState) => {
  const { claimInfo, claimInfoDH } = getState().apply;
  claimInfo[key] = value;
  dispatch({
    type: 'SET_CLAIMINFO',
    claimInfo: { ...claimInfo },
    claimInfoDH: { ...claimInfoDH }
  });
};

// 提交申请
export const submitCarApply = (claimInfo) => async (dispatch) => {
  try {
    const result = await window.HWH5.fetch(urls.addCarApply, {
      method: 'post',
      body: JSON.stringify(claimInfo),
      headers: { 'Content-Type': 'application/json' }
    }).then(res => res.json().then(reply => reply).catch(error => {
      window.HWH5.loading({ status: false });
      console.log(error, 'error');
      window.HWH5.toast({ msg: i18n.t('common:submitFail'), type: 'n' });
    }));
    // 发送请求
    // 得到的结果result
    // const result = { message: 'add sucess', code: '0', data: '4455sddfsf' };
    await dispatch({ type: 'SUBMIT_CAR', result }); 
    window.HWH5.loading({ status: false });
    return result;
  } catch (error) {
    window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
    console.log(error, 'error22');
    return error;
  }
};
