/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:41:20
* @project : We码 物品领用
* @description : 详情页面 detail action
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:41:20
*
*/

import i18n from 'i18n';
import { urls, debug } from '../config/web.config';
import DETAILLIST from '../dummy/detailList.json';

// 重置redux 详情数据
export const _initClaimDetail = () => (dispatch) => {
  dispatch({ type: 'initClaimDetail' });
};

// 获取数据详情
const receiveFetchDetail = response => ({
  type: 'RECEIVE_FETCHDETAIL',
  claimDetail: response
});

// 请求详情数据
export const getFetchDetail = detailId => async (dispatch, getState) => {
// 请求
  try {
    // window.HWH5.loading({ status: true });
    if (debug) {
      window.HWH5.loading({ status: false });
      dispatch(receiveFetchDetail(DETAILLIST.data));
      return DETAILLIST.data;
    }
    const url = `${urls.detail}${detailId}`;
    const resultObj = await window.HWH5.fetch(url).then((res) => { 
      window.HWH5.loading({ status: false });
      return res.json();
    }).then((reply) => reply).catch((error) =>{
      console.log('1error: ', error);
      window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
      return error;
    });
    dispatch(receiveFetchDetail(resultObj.data));
    window.HWH5.loading({ status: false });
    return resultObj.data;
  } catch (error) {
    window.HWH5.loading({ status: false });
    console.log('error: ', error);
    return error;
  }
};

// 更改审批状态
const receiveApproval = response => ({
  type: 'RECEIVE_APPROVAL',
  claimDetail: response
});

export const setApproval = (param) => async (dispatch, getState) => {
  try {
    // window.HWH5.loading({ status: true });
    const _headers = {
      'Content-Type': 'application/json'
    };
    const result = await window.HWH5.fetch(urls.approve, {
      method: 'post',
      body: JSON.stringify(param),
      headers: _headers
    })
      .then(res => res.json())
      .catch(error => {
        window.HWH5.loading({ status: false });
        console.log('1error: ', error);
        window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
      });
    //  结果
    // 模拟数据
    // const result = { message: 'approve sucess', code: '0' };
    window.HWH5.loading({ status: false });
    dispatch(receiveApproval(result));
    return result;
  } catch (error) {
    return error;
  }
};
