/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:43:00
* @project : We码 物品领用
* @description : App 公共 action
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:43:00
*
*/

// 获取用户信息
const receiveCurrentUser = (response) => ({
  type: 'CURRENT_USER',
  userInfo: response
});

export const getUserInfo = () => async (dispatch, getState) => {
  try {
    const response = await window.HWH5.userInfo().then((data)=> data);
    await dispatch(receiveCurrentUser(response));
    return response;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 设置是否重新加载
const reload = (response) => ({
  type: 'RELOAD',
  reload: response
});

export const setReload = (bool) => async (dispatch) => {
  try {
    await dispatch(reload(bool));
    return bool;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 设置详情数据的index值
const setInvoivceIndex = (response) => ({ type: 'SET_INDEX', index: response });

export const setIndex = (key) => async (dispatch) => {
  try {
    await dispatch(setInvoivceIndex(key));
    return key;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 设置列表页的tab值
const setInvoivceTab = (response) => ({ type: 'SET_TAB', tab: response });

export const setTab = (key) => async (dispatch) => {
  try {
    await dispatch(setInvoivceTab(key));
    return key;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 设置申请数据的value值
const setInvoivceValue = (response) => ({ type: 'SET_VALUE', value: response });

export const setValue = (key) => async (dispatch) => {
  try {
    await dispatch(setInvoivceValue(key));
    return key;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 设置审批数据的value值
const setInvoivceAppValue = (response) => ({ type: 'SET_APPVALUE', approveValue: response });

export const setAppValue = (key) => async (dispatch) => {
  try {
    await dispatch(setInvoivceAppValue(key));
    return key;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};
