/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:44:07
* @project : We码 物品领用
* @description : App 首页 home action
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:44:07
*
*/

import i18n from 'i18n';
import { urls, debug } from '../config/web.config';
import APPLYDATE from '../dummy/applyList.json';
import APPROVEDATE from '../dummy/approveList.json';

// 保存列表数据
const myListFetch = (type, response) => ({
  type,
  dataList: response
});

// 保存状态数据
const stateFetch = (type, response) => ({
  type,
  stateList: response
});

// 保存数据总条数
const toatlFetch = (response) => ({
  type: 'IN_TOTAL',
  inApproveTotal: response
});

// 保存是否有更多数据
const hasMoreFn = (response) => ({
  type: 'HAS_MORE',
  hasMore: response
});

// 请求申请数据列表
const getClaimAction = (obj, approveState) => {
  if (debug) {
    console.log(APPLYDATE);
    return APPLYDATE;
  }
  const url = `${urls.applyList}curPage=${obj.page}&pageSize=${10}&approveState=${approveState}`;
  const resObj = window.HWH5.fetch(url).then((res) => res.json()
    .then((reply) => reply).catch((error) => {
      window.HWH5.loading({ status: false });
      console.log('1error: ', error);
      window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
      return error;
    }));
  return resObj;
};

// 我的申请列表
export const getCarMyList = (applyObj, approveState, showMore) => async (dispatch) => {
  try {
    if (applyObj.isload) {
      if (showMore) {
        window.HWH5.loading({ status: true });
        const resObj = await getClaimAction(applyObj, approveState);
        applyObj.list = applyObj.list.concat(resObj.data.list);
        switch (approveState) {
          case 0: {
            await dispatch(stateFetch('APPLY_ALL', applyObj));
            break;
          }
          case 1: {
            await dispatch(stateFetch('APPLY_EXAMINE', applyObj));
            break;
          }
          case 2: {
            await dispatch(stateFetch('APPLY_PASS', applyObj));
            break;
          }
          case 3: {
            await dispatch(stateFetch('APPLY_REJECT', applyObj));
            break;
          }
        }
        await dispatch(myListFetch('CLAIM_MYLIST', applyObj.list));
        return resObj.data.list;
      }
      await dispatch(myListFetch('CLAIM_MYLIST', applyObj.list));
      return applyObj.list;
    } else {
      window.HWH5.loading({ status: true });
      const resObj = await getClaimAction(applyObj, approveState);
      if (debug) { // 如果没有debug，可以直接写applyObj.list = resObj.data.list
        const arr = [];
        let i = 0;
        resObj.data.list.forEach((item) => {
          if (item.approveState === approveState) {
            arr[i] = item;
            i++;
            console.log(item);
            console.log(arr);
          }
        });
        if (approveState === 0) {
          applyObj.list = resObj.data.list;
        } else {
          console.log(arr, 'arr');
          applyObj.list = arr;
        }
      } else {
        applyObj.list = resObj.data.list;
      }
        
      applyObj.isload = true;
      switch (approveState) {
        case 0: {
          await dispatch(stateFetch('APPLY_ALL', applyObj));
          break;
        }
        case 1: {
          await dispatch(stateFetch('APPLY_EXAMINE', applyObj));
          break;
        }
        case 2: {
          await dispatch(stateFetch('APPLY_PASS', applyObj));
          break;
        }
        case 3: {
          await dispatch(stateFetch('APPLY_REJECT', applyObj));
          break;
        }
      }
      await dispatch(myListFetch('CLAIM_MYLIST', applyObj.list));
      return resObj.data.list;
    }
  } catch (error) {
    window.HWH5.loading({ status: false });
    window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
    return error;
  }
};

// 重设状态页码
export const setPage = (obj, page, value) => async (dispatch) => {
  try {
    obj.page = page;
    switch (value) {
      case 'applyAll': {
        await dispatch(stateFetch('APPLY_ALL', obj));
        break;
      }
      case 'applyExamine': {
        await dispatch(stateFetch('APPLY_EXAMINE', obj));
        break;
      }
      case 'applyPass': {
        await dispatch(stateFetch('APPLY_PASS', obj));
        break;
      }
      case 'applyReject': {
        await dispatch(stateFetch('APPLY_REJECT', obj));
        break;
      }
      case 'approveAll': {
        await dispatch(stateFetch('APPROVE_ALL', obj));
        break;
      }
      case 'inapproval': {
        await dispatch(stateFetch('IN_APPROVAL', obj));
        break;
      }
      case 'approved': {
        await dispatch(stateFetch('APPROVED', obj));
        break;
      }
    }
    return obj;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 重设状态是否有更多
export const handleMore = (obj, bol, value) => async (dispatch) => {
  try {
    obj.hasMore = bol;
    switch (value) {
      case 'applyAll': {
        await dispatch(stateFetch('APPLY_ALL', obj));
        break;
      }
      case 'applyExamine': {
        await dispatch(stateFetch('APPLY_EXAMINE', obj));
        break;
      }
      case 'applyPass': {
        await dispatch(stateFetch('APPLY_PASS', obj));
        break;
      }
      case 'applyReject': {
        await dispatch(stateFetch('APPLY_REJECT', obj));
        break;
      }
      case 'approveAll': {
        await dispatch(stateFetch('APPROVE_ALL', obj));
        break;
      }
      case 'inapproval': {
        await dispatch(stateFetch('IN_APPROVAL', obj));
        break;
      }
      case 'approved': {
        await dispatch(stateFetch('APPROVED', obj));
        break;
      }
    }
    await dispatch(hasMoreFn(obj.hasMore));
    return obj;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 重设状态是否请求
export const restLoad = (obj, bol, value) => async (dispatch) => {
  try {
    obj.isload = bol;
    switch (value) {
      case 'applyAll': {
        await dispatch(stateFetch('APPLY_ALL', obj));
        break;
      }
      case 'applyExamine': {
        await dispatch(stateFetch('APPLY_EXAMINE', obj));
        break;
      }
      case 'applyPass': {
        await dispatch(stateFetch('APPLY_PASS', obj));
        break;
      }
      case 'applyReject': {
        await dispatch(stateFetch('APPLY_REJECT', obj));
        break;
      }
      case 'approveAll': {
        await dispatch(stateFetch('APPROVE_ALL', obj));
        break;
      }
      case 'inapproval': {
        await dispatch(stateFetch('IN_APPROVAL', obj));
        break;
      }
      case 'approved': {
        await dispatch(stateFetch('APPROVED', obj));
        break;
      }
    }
    return obj;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 重设参数
export const restParam = (obj, value) => async (dispatch) => {
  try {
    obj.isload = false;
    obj.list = [];
    obj.hasMore = true;
    obj.page = 1;
    obj.total = 0;
    switch (value) {
      case 'applyAll': {
        await dispatch(stateFetch('APPLY_ALL', obj));
        break;
      }
      case 'applyExamine': {
        await dispatch(stateFetch('APPLY_EXAMINE', obj));
        break;
      }
      case 'applyPass': {
        await dispatch(stateFetch('APPLY_PASS', obj));
        break;
      }
      case 'applyReject': {
        await dispatch(stateFetch('APPLY_REJECT', obj));
        break;
      }
      case 'approveAll': {
        await dispatch(stateFetch('APPROVE_ALL', obj));
        break;
      }
      case 'inapproval': {
        await dispatch(stateFetch('IN_APPROVAL', obj));
        break;
      }
      case 'approved': {
        await dispatch(stateFetch('APPROVED', obj));
        break;
      }
    }
    return obj;
  } catch (error) {
    console.log('error: ', error);
    return error;
  }
};

// 待我审批的请求
const getApproveAction = (obj, approveState) => { 
  if (debug) {
    return APPROVEDATE;
  }
  const url = `${urls.approveList}curPage=${obj.page}&pageSize=${10}&approveState=${approveState}`;
  const resObj = window.HWH5.fetch(url).then((res) => res.json()
    .then((reply) => reply).catch((error) => {
      console.log('1error: ', error);
      window.HWH5.loading({ status: false });
      window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
      return error;
    }));
  return resObj;
};

// 待我审批列表
export const getApproveList = (approveObj, approveState, showMore) => async (dispatch) => {
  try {
    if (approveObj.isload) {
      if (showMore) {
        window.HWH5.loading({ status: true });
        const resObj = await getApproveAction(approveObj, approveState);
        approveObj.list = approveObj.list.concat(resObj.data.list);
        approveObj.total = resObj.data.inApproveTotal;
        switch (approveState) {
          case 0: {
            await dispatch(stateFetch('APPROVE_ALL', approveObj));
            break;
          }
          case 1: {
            await dispatch(stateFetch('IN_APPROVAL', approveObj));
            break;
          }
          case 4: {
            await dispatch(stateFetch('APPROVED', approveObj));
            break;
          }
        }
        await dispatch(myListFetch('CLAIM_APPROVELIST', approveObj.list));
        return resObj.data.list;
      }
      await dispatch(myListFetch('CLAIM_APPROVELIST', approveObj.list));
      return approveObj.list;
    } else {
      window.HWH5.loading({ status: true });
      const resObj = await getApproveAction(approveObj, approveState);
      if (debug) {
        const arr = [];
        let i = 0;
        resObj.data.list.forEach((item) => {
          console.log(item, approveState);
          if (approveState === 4) {
            if (item.approveState !== 1) {
              arr[i] = item;
              i++;
            }
          } else if (approveState === item.approveState) {
            arr[i] = item;
            i++;
          }
        });
        if (approveState === 0) {
          approveObj.list = resObj.data.list;
        } else {
          approveObj.list = arr;
        }
      } else {
        approveObj.list = resObj.data.list;
      }
      approveObj.total = resObj.data.inApproveTotal;
      approveObj.isload = true;
      await dispatch(toatlFetch(approveObj.total));
      switch (approveState) {
        case 0: {
          await dispatch(stateFetch('APPROVE_ALL', approveObj));
          break;
        }
        case 1: {
          await dispatch(stateFetch('IN_APPROVAL', approveObj));
          break;
        }
        case 4: {
          await dispatch(stateFetch('APPROVED', approveObj));
          break;
        }
      }
      await dispatch(myListFetch('CLAIM_APPROVELIST', approveObj.list));
        
      return approveObj.list;
    }
  } catch (error) {
    window.HWH5.loading({ status: false });
    window.HWH5.toast({ msg: i18n.t('common:No network'), type: 'w' });
    return error;
  }
};

// 设置详情id
export const setDetailid = (type, detailId) => async (dispatch) => {
  await dispatch(myListFetch('CLAIM_MYDETAIL', { type, detailId }));
};
