/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 15:19:13
* @project : We码 物品领用
* @description : 物品申请页面 物品明细输入框组件
*
* @last modified by : jiys
* @last modified time : 2018-12-12 15:19:13
*
*/

import React from 'react';
import PropTypes from 'prop-types';
import i18n from 'i18n';
import {
  Cells,
  Cell,
  CellBody
} from '@wecode/react-weui';
import './index.less';
import redStar from '../../routes/Apply/images/redStar.png';

export default class Article extends React.Component {
  
  componentWillMount() {
  }

  render() {
    const {
      goodsName, amount, more, index, deleteButton, change
    } = this.props;
    return (
      <div>
        <div className="flex article">
          <div className="header" style={{ lineHeight: 1.5 }}>
            {i18n.t('common:Detail')} {'(' + (index + 1) + ')'}
          </div>
          
          { deleteButton !== 1 && (
            <div className="footer" onClick={() => more(index)} style={{ lineHeight: 1.5 }}>
              {i18n.t('common:Delete')}
            </div>
          )}
        </div>
        <Cells>
          <Cell className="commonCell time">
            <img src={redStar} alt="" className="redStar" />
            <CellBody className="header">
              {/* 物品名称 */}
              {i18n.t('common:GoodsName')}
            </CellBody>
            <div style={{ paddingRight: '10px', width: '65vw' }}>
              <input
                className="weui-input"
                type="text" 
                placeholder={i18n.t('common:-Enter Name-')}
                value={goodsName}
                maxLength="20" 
                style={{ textAlign: 'right', fontSize: '14px' }}
                onChange={(val) => change('goodsName', val.target.value, index)}
              />
            </div>
          </Cell>
          <Cell className="commonCell time">
            <img src={redStar} alt="" className="redStar" />
            <CellBody className="header">
              {/* 数量 */}
              {i18n.t('common:Amount')}
            </CellBody>
            <div style={{ paddingRight: '10px', width: '65vw' }}>
              <input
                className="weui-input"
                type="tel"
                placeholder={i18n.t('common:-Enter Num-')}
                value={amount}
                maxLength="5"
                style={{ textAlign: 'right', fontSize: '14px' }}
                onChange={(val) => change('amount', val.target.value, index)}
              />
            </div>
          </Cell>
        </Cells>  
      </div>
    );
  }
} 

Article.propTypes = {
  goodsName: PropTypes.string,
  amount: PropTypes.string,
  more: PropTypes.func,
  index: PropTypes.number,
  deleteButton: PropTypes.number,
  change: PropTypes.func
};
