/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 15:24:40
* @project : We码 物品领用
* @description : 物品列表页 数据缺省提示组件
*
* @last modified by : jiys
* @last modified time : 2018-12-12 15:24:40
*
*/

import React from 'react';
import PropTypes from 'prop-types';
import i18n from 'i18n';
import {
  ExceptionTip
} from '@wecode/react-weui';
import './index.less';

export default class ExceptionTips extends React.Component {

    state = {
      flag: 1,
      submsg: '',
      // msg: '暂无内容',
      msg: i18n.t('common:No content'),
      callback: '',
      children: '',
      appHeight: 0
    };  

    componentWillMount() { 
      this.setState({ appHeight: window.innerHeight });
    }

    render() {
      const { 
        flag, submsg, msg, callback, children, appHeight
      } = this.state;
      const { heightFrom } = this.props;
      return (
        <div>
          <ExceptionTip
            flag={flag}
            callback={callback}
            msg={msg}
            submsg={submsg}
            style={{ marginTop: heightFrom, height: appHeight }}
          >
            {children}
          </ExceptionTip>
        </div>
      );
    }
} 

ExceptionTips.propTypes = {
  heightFrom: PropTypes.string
};

