/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 15:07:32
* @project : We码 物品领用
* @description : 物品列表项组件
*
* @last modified by : jiys
* @last modified time : 2018-12-12 15:07:32
*
*/

import React from 'react';
import PropTypes from 'prop-types';
import i18n from 'i18n';
import './index.less';

const renderDem = (data, index, onClick, userInfo)=> (
  <div 
    key={index} 
    className="list_box__hd" 
    style={{ padding: '0 16px 7px' }} 
    onClick={()=> (onClick ? onClick({ id: data.id, 'index': index }) : ()=>{})}
  >
    <div className="list_box__hd_title">
      <div 
        className="list_box__hd_title_left"
        style={{ 
          display: 'inline-block', 
          overflow: 'hidden', 
          whiteSpace: 'nowrap', 
          textOverflow: 'ellipsis',
          maxWidth: '65vw'
        }}
      >
        {i18n.language === 'zh_CN' && (data.applyCnName + '的物品领用')}
        {i18n.language === 'en_US' && ('Claim Items from ' + data.applyEnName)}
      </div>
      <div className="list_box__hd_title_right">{data.applyDate.split(' ')[0]}</div>
    </div>  
    <div className="list_box__hd_body clearfix">
      <div className="list_box__hd_body_left">
        <div className="list_box_hd_body_detail">
          <div>
            <span className="list_box_hd_name">{i18n.t('Requested by')}：{data.goodsName}</span>
          </div>
          {data.applyId === userInfo.uid && (
            <div>
              <span>
                {/* 审批人： */}
                {i18n.t('common:Approvers')}：
              </span>
              <span>
                {i18n.language === 'zh_CN' && data.approveCnName}
                {i18n.language === 'en_US' && data.approveEnName}
              </span>
            </div>
          )}
        </div>
      </div>
      <div className="list_box__hd_body_right">
        {data.applyId === userInfo.uid && (  
          <span 
            className={`list_box__hd_body_status${'_' + data.approveState}`}
            style={{ lineHeight: 2.5 }}
          >
            {data.approveState === 1 ? i18n.t('common:Approving') : (data.approveState === 2 ? i18n.t('common:Approved') : i18n.t('common:Rejected'))}
          </span>
        )}
        {data.applyId !== userInfo.uid && (  
          <span 
            className={`list_box__hd_body_status${'_' + data.approveState}`}
            style={{ lineHeight: 1.3 }} 
          >
            {data.approveState === 1 ? i18n.t('common:Approving') : (data.approveState === 2 ? i18n.t('common:Approved') : i18n.t('common:Rejected'))}
          </span>
        )}
      </div>
    </div>
  </div>
);

const ListBox = props => {
  const { data, onClick, userInfo } = props;
  return (
    <div className="list_box__bg">
      {data.length > 0 && (
        data.map((param, index)=>renderDem(param, index, onClick, userInfo))
      )
      }
    </div>
  );
};

ListBox.propTypes = {
  data: PropTypes.array,
  onClick: PropTypes.func,
  userInfo: PropTypes.object
};

export default ListBox;
