/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : jiys
* @date : 2018-12-13 16:21:00
* @project : We码 物品领用
* @description : 前端基本配置文件，可配置对应环境的接口地址
*
* @last modified by : jiys
* @last modified time : 2018-12-13 16:21:00
*
*/

let configs = {};

if (process.env.APP_ENV === 'production') {
  configs = {
    prefix: {
      mcloud: 'https://error-url/wecar/',
      headIconUrl: 'https://cloudlinkworkplace-api.huaweicloud.com/mcloud/mag/ProxyForImage/w3labyellowpage/face/{0}/120?method=getStream'
    },
    debug: true // 如果设置为空，会去请求后台数据，否则使用./../dummy中的数据
  };
} else if (process.env.APP_ENV === 'uat') {
  configs = {
    prefix: {
      mcloud: 'http://error-url/wecar/',
      headIconUrl: 'https://cloudlinkworkplace-api.huaweicloud.com/mcloud/mag/ProxyForImage/w3labyellowpage/face/{0}/120?method=getStream'
    },
    debug: true
  };
} else {
  // 本地开发
  console.log(process.env.APP_ENV);
  configs = {
    prefix: {
      mcloud: 'http://error-url/wecar/',
      headIconUrl: 'https://cloudlinkworkplace-api.huaweicloud.com/mcloud/mag/ProxyForImage/w3labyellowpage/face/{0}/120?method=getStream'
    },
    debug: true
  };
}

const {
  prefix,
  debug
} = configs;

module.exports = {
  urls: { // 接口地址配置
    getData: `${prefix.mcloud}getData`,
    addCarApply: `${prefix.mcloud}rest/goods/apply/add`, // 新建用车申请
    applyList: `${prefix.mcloud}rest/goods/apply/list?`, // 我的申请列表
    approveList: `${prefix.mcloud}rest/goods/approve/list?`, // 我的审批列表
    detail: `${prefix.mcloud}rest/goods/getById/`, // 获取用车详情
    approve: `${prefix.mcloud}rest/goods/approve`, // 审批填写接口,
    headIcon: prefix.headIconUrl // 获取头像
  },
  debug
};
