/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:53:39
* @project : We码 物品领用
* @description : 首页 home reducer
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:53:39
*
*/

// 初始化状态
const initState = {
  homeInfo: {},
  myList: [], 
  hasMore: true, // 加载更多
  inApproveTotal: 0, // 审批中的数据总数
  applyAll: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1
  },
  applyPass: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1
  },
  applyExamine: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1
  },
  applyReject: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1
  },
  approveAll: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1,
    total: 0
  },
  approved: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1,
    total: 0
  },
  inapproval: {
    isload: false,
    list: [],
    hasMore: true,
    page: 1,
    total: 0
  }
};

export function home(state = initState, action) {
  switch (action.type) {
    case 'RECEIVE_HOME':
      return {
        ...state,
        homeInfo: action.homeInfo
      };
    case 'CLAIM_MYLIST':
      return {
        ...state,
        myApplyList: action.dataList
      };
    case 'CLAIM_APPROVELIST':
      return {
        ...state,
        myApproveList: action.dataList
      };
    case 'CLAIM_MYDETAIL': 
      return {
        ...state,
        myDetail: action.dataList
      };
    case 'APPLY_ALL': {
      return {
        ...state,
        applyAll: action.stateList
      };
    }
    case 'APPLY_PASS': {
      return {
        ...state,
        applyPass: action.stateList
      };
    }
    case 'APPLY_EXAMINE': {
      return {
        ...state,
        applyExamine: action.stateList
      };
    }
    case 'APPLY_REJECT': {
      return {
        ...state,
        applyReject: action.stateList
      };
    }
    case 'HAS_MORE': {
      return {
        ...state,
        hasMore: action.hasMore
      };
    }
    case 'APPROVE_ALL': {
      return {
        ...state,
        approveAll: action.stateList
      };
    }
    case 'APPROVED': {
      return {
        ...state,
        approved: action.stateList
      };
    }  
    case 'IN_APPROVAL': {
      return {
        ...state,
        inapproval: action.stateList
      };
    }
    case 'IN_TOTAL': {
      return {
        ...state,
        inApproveTotal: action.inApproveTotal
      };
    }
    
    default:
      return { ...state };
  }
};
