/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 12:06:04
* @project : We码 物品领用
* @description : 物品领用 申请页面
*
* @last modified by : jiys
* @last modified time : 2018-12-12 12:06:04
*
*/

import React from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import {
  Cells,
  Cell,
  CellBody,
  Form,
  Button,
  FormCell,
  TextArea,
  CellsTitle,
  Tab,
  TabBody,
  Grid,
  Dialog
} from '@wecode/react-weui';
import PropTypes from 'prop-types';
import i18n from 'i18n';
import Article from '../../components/Article';
import * as global from '../../actions/global';
import * as apply from '../../actions/apply';
import * as home from '../../actions/home';
import isios from '../../utils/isiOS.js';
import { toast, maxLengthFive } from '../../utils/const.js';
// import IconBox from '../../components/IconBox';
import { urls, debug } from '../../config/web.config';
import './index.less';
import userSrc from './images/defaultface.png';
import redStar from './images/redStar.png';
import addUserSrc from './images/adduser.png';
import picdel from './images/picdel.png';
import addList from './images/addList.png';

@connect(
  state => ({ ...state.apply, ...state.global, ...state.home }),
  dispatch => bindActionCreators({ ...apply, ...global, ...home }, dispatch)
)
export default class Apply extends React.Component {
  state = {
    applyHeight: window.innerHeight,
    positionStyle: 'fixed',
    handleList: [{ goodsName: '', amount: '' }],
    showDialog: false,
    deleteIndex: 0
  }

  componentWillMount() {
    const { 
      _initStateData 
    } = this.props;
    _initStateData();
    window.HWH5.navTitle({ title: i18n.t('common:Ride Request') });
  }

  // 组件加载完成
  componentDidMount() {
    const { applyHeight } = this.state;
    this.setState({ applyHeight: window.innerHeight });
    if (isios) {
      this.setState({ positionStyle: 'absolute' });
      document.getElementById('remarkBox').addEventListener('focus', () => {
        document.getElementById('subBtn').style.display = 'none';
      });
      document.getElementById('remarkBox').addEventListener('blur', () => {
        document.getElementById('subBtn').style.display = 'block';
      });
    } else {
      window.addEventListener('resize', () => {
        if (document.activeElement.tagName === 'TEXTAREA' || document.activeElement.tagName === 'INPUT') {
          setTimeout((e) => {
            document.activeElement.scrollIntoViewIfNeeded();
          }, 0);
        }
        if (window.innerHeight < applyHeight) {
          this.setState({ positionStyle: 'static' });
        } else {
          this.setState({ positionStyle: 'fixed' });
        }
      });
    }
  }

  // 动态展示用户头像
  showFaceImg = (userId) => {
    const imgSrc = this.isNotEmpty(userId) ? (userId === 'add' ? addUserSrc : urls.headIcon.replace('{0}', userId)) : userSrc;
    return <img src={imgSrc} onError={(img) => { img.target.src = userSrc; }} alt="" />; 
  }

  // 判断是否为空
  isNotEmpty = (value) => {
    if (typeof value !== 'undefined' && value !== null && value !== '') {
      return true;
    }
    return false;
  }

  handleApproverInfo = () => { // 选人
    document.getElementById('subBtn').style.display = 'block';
    const { setClaimInfo, userInfo } = this.props;
    const param = {
      bundleName: '', // 必传，可以为空
      needCallback: true, // 必传，布尔类型。是否需要回调，将返回选中的联系人相关信息
      isSingleSelection: true, // 可选，是否单选，默认false
      mode: 0, // 可选，选择模式 0，包含选择联系人的基本信息
      dataSourceType: 1, // 可选, 我的内部联系人 1
      title: i18n.t('common:Select approver'), // 可选, 选人组件自定义标题
      supportPortals: 1, // 选人组件顶部支持的入口定义：我的联系人 1
      fixedFlag: 2 // 特殊场景标志位：1 已选中不可操作的人员显示在顶部头像展示栏；2 返回数据包含已选中不可操作的人员
    };
    window.HWH5.selectContacts(param).then(async result => {
      if (result && result.data) {
        const id = result.data[0].w3account.toLowerCase();
        if (id === userInfo.uid.toLowerCase()) {
          toast(i18n.t('common:You cannot select yourself as the approver'));
          return false;
        } 
        await setClaimInfo('approveId', id);
        await setClaimInfo('approveCnName', (result.data[0].chineseName !== '' ? result.data[0].chineseName : result.data[0].englishName));
        await setClaimInfo('approveEnName', (result.data[0].englishName !== '' ? result.data[0].englishName : result.data[0].chineseName));
      }
      this.refs.approve.scrollIntoView();
      return false;
    }).catch((error) => {
      console.log(error, 'error');
    });
  }

  // 删除审核人
  onDeleteApprove = async ()=>{
    const { setClaimInfo } = this.props;
    await setClaimInfo('approveId', '');
    await setClaimInfo('approveCnName', '');
    await setClaimInfo('approveEnName', '');
  }

  // 失去焦点
  onNoneFocus = () => {
    this.refNoneFacus.focus();
  }

  // 新建 提交
  commitCarApply = async ()=>{
    document.activeElement.blur();
    const { 
      claimInfo = {}, submitCarApply, history, _initStateData, setClaimInfo,
      restParam, setTab, approveAll, inapproval, approved, applyAll, applyPass,
      applyExamine, applyReject, setReload
    } = this.props;
    const { handleList } = this.state;
    const paramskeys = [
      { key: 'goodsUse', msg: i18n.t('common:Purpose is required') },
      { key: 'instruction', msg: i18n.t('common:Instruction is required') },
      { key: 'approveId', msg: i18n.t('common:Approvers is required') },
      { key: 'approveCnName', msg: i18n.t('common:Approvers is required') },
      { key: 'approveEnName', msg: i18n.t('common:Approvers is required') }
    ];
    const emptyParams = paramskeys.filter(param => !this.isNotEmpty(claimInfo[param.key]));
    // 必填信息不能为空，为空则提示相应的msg
    if (!claimInfo.goodsUse) {
      return toast(i18n.t('common:Purpose is required'));
    }

    for (let i = 0; i < handleList.length; i++) {
      if (!handleList[i].goodsName) {
        return toast(i18n.t('common:GoodsName is required'));
      }

      if (!handleList[i].amount) {
        return toast(i18n.t('common:Amount is required'));
      }

      if (!/^\+?[1-9][0-9]*$/.test(handleList[i].amount)) {
        return toast(i18n.t('common:AmountUncorrect'));
      }

      if (typeof Number(handleList[i].amount) !== 'number') {
        return toast(i18n.t('common:AmountUncorrect'));
      }
    }

    if (debug) {
      toast(i18n.t('common:Submitted Successfully'));
      setTab(3);
      setReload(true);
      return history.goBack();
    }

    if (emptyParams.length > 0) { 
      return toast(emptyParams[0].msg);
    }
    claimInfo.list = handleList;
    setClaimInfo('approveState', '1');
    const reply = await submitCarApply(claimInfo);
    if (reply && reply.code === '0') {
      _initStateData();
      toast(i18n.t('common:Submitted Successfully'));
      restParam(approveAll, 'approveAll');
      restParam(inapproval, 'inapproval');
      restParam(approved, 'approved');
      restParam(applyAll, 'applyAll');
      restParam(applyPass, 'applyPass');
      restParam(applyExamine, 'applyExamine');
      restParam(applyReject, 'applyReject');
      setTab(3);
      setReload(true);
      return history.goBack();
    }
    toast(reply.message);
    console.log(reply, '提交失败返回reply');
    return false;
  }

  // 添加
  addList() {
    const { handleList } = this.state;
    handleList.push({ goodsName: '', amount: '' });
    this.setState({ 'handleList': handleList });
  }

  // 删除 
  deleteList() {
    const { handleList, deleteIndex } = this.state;
    handleList.map((item, index) => {
      if (index === deleteIndex) {
        handleList.splice(index, 1);
      }
      return this.setState({ 
        'handleList': handleList,
        showDialog: false
      });
    });
  }

  // 改变
  changeList(type, value, index) {
    const { handleList } = this.state;
    if (type === 'goodsName') {
      handleList[index].goodsName = value;
    } else {
      maxLengthFive(value);
      handleList[index].amount = value;
    }
    this.setState({ 'handleList': handleList });
  }
  
  render() {
    const { 
      claimInfo = {}, 
      setClaimInfo
    } = this.props;
    const { 
      applyHeight, 
      positionStyle,
      handleList,
      showDialog
    } = this.state;
    
    return (
      <div 
        className="Apply app_detail_bg" 
        style={{ height: applyHeight, position: 'relative' }} 
        onClick={this.onNoneFocus.bind(this)}
      >
        <Tab>
          <TabBody>
            <div style={{ borderTop: '1px solid transparent', height: '100%', position: 'relative' }}>
              <div style={{ overflow: 'auto' }}> 
                <input type="radio" className="none-input" ref={(el) => { this.refNoneFacus = el; }} />
                {/* 物品用途 */}
                <Cells>
                  <Cell className="commonCell time">
                    <img src={redStar} alt="" className="redStar" />
                    <CellBody className="header">
                      {i18n.t('common:Purpose')}
                    </CellBody>
                    <div style={{ paddingRight: '10px', width: '65vw' }}>
                      <input
                        className="weui-input"
                        type="text" 
                        placeholder={i18n.t('common:Purpose answer')}
                        value={!claimInfo.goodsUse || claimInfo.goodsUse === '' ? '' : claimInfo.goodsUse}
                        maxLength="200" 
                        style={{ textAlign: 'right', fontSize: '14px' }}
                        onChange={val => setClaimInfo('goodsUse', val.target.value)}
                      />
                    </div>
                  </Cell>
                </Cells>
                {/* 领用物品 */}
                {
                  handleList.map((item, index) => (
                    <Article
                      key={index}
                      index={index}
                      goodsName={item.goodsName}
                      amount={item.amount}
                      deleteButton={handleList.length}
                      more={e => this.setState({ 
                        showDialog: true,
                        deleteIndex: e 
                      })}
                      change={this.changeList.bind(this)}
                    />
                  ))
                }
                <Cells className="addList" onClick={e => this.addList(e)}>
                  <img src={addList} alt="" className="add" />
                  <span>{i18n.t('common:Add Item')}</span> 
                </Cells>
                {/* 备注文本框 */}
                <Cells>
                  <CellsTitle className="spaciess">
                    
                    <div className="flex">
                      <img src={redStar} alt="" className="redStar" />
                      <div className="header" style={{ lineHeight: 1.5 }}>
                        {/* 备注 */}
                        {i18n.t('common:Remarks')}
                      </div>
                    </div>
                  </CellsTitle>
                  <Form style={{ marginTop: 0 }}>
                    <FormCell className="inputContent">
                      <CellBody>
                        <TextArea
                          id="remarkBox"
                          style={{ fontSize: '14px' }}
                          placeholder={i18n.t('common:Enter extra information')}
                          rows="3"
                          maxLength="1000"
                          value={claimInfo.instruction}
                          onChange={val => setClaimInfo('instruction', val.target.value)}
                        />
                      </CellBody>
                    </FormCell>
                  </Form>
                </Cells>
                {/* 审批人 */}
                <Cells className="approver detail__icon-box" style={{ marginBottom: '65px' }}>
                  <Cell>
                    <img src={redStar} alt="" className="redStar" />
                    <CellBody className="header">
                      {/* 审批人 */}
                      {i18n.t('common:Approvers')}
                    </CellBody>
                  </Cell>
                  <Form style={{ overflow: 'initial' }}>
                    <FormCell style={{ padding: '0 20px' }}>
                      <CellBody>
                        <div ref="approve">
                          {/* 当审核人为空时 */}
                          { !this.isNotEmpty(claimInfo.approveId) && <Grid icon={this.showFaceImg('add')} label="&nbsp;" onClick={this.handleApproverInfo} /> }
                          { this.isNotEmpty(claimInfo.approveId) 
                        && (
                          <Grid 
                            icon={this.showFaceImg(
                              claimInfo.approveId.toLowerCase()
                            )}
                            label={i18n.language === 'zh_CN' ? claimInfo.approveCnName : claimInfo.approveEnName}
                          >
                            <img src={picdel} alt="" className="picDeleteBtn" onClick={this.onDeleteApprove} />
                          </Grid>) }
                        </div>
                      </CellBody>
                    </FormCell>
                  </Form>
                </Cells>
              </div>
            </div>
          </TabBody>
        </Tab>
        <div className="addBtn" id="subBtn" style={{ zIndex: '100', position: positionStyle }}>
          <Button 
            onClick={this.commitCarApply} 
          > 
            {i18n.t('common:Submit')}
          </Button>
        </div>

        <Dialog
          className="dismiss-dialog"
          title={i18n.t('common:Delete this record')}
          show={showDialog}
          buttons={[
            {
              type: 'default',
              label: i18n.t('common:Cancel'),
              onClick: () =>{ this.setState({ showDialog: false });document.activeElement.blur(); }
            },
            {
              type: 'default',
              label: i18n.t('common:OK'),
              onClick: () => this.deleteList()
            }
          ]}
        />  
      </div>
    );
  }
}

Apply.propTypes = {
  claimInfo: PropTypes.object,
  setClaimInfo: PropTypes.func,
  userInfo: PropTypes.object,
  _initStateData: PropTypes.func
};
