/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 12:05:32
* @project : We码 物品领用
* @description : 物品领用 详情页面
*
* @last modified by : jiys
* @last modified time : 2018-12-12 12:05:32
*
*/

import React from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import {
  Cells,
  Cell,
  CellBody,
  Form,
  Button,
  FormCell,
  TextArea,
  CellsTitle,
  Dialog,
  ButtonArea,
  Tab,
  TabBody,
  TabBarItem,
  TabBar
} from '@wecode/react-weui';
import i18n from 'i18n';
import * as home from '../../actions/home';
import * as global from '../../actions/global';
import * as detail from '../../actions/detail';
import defaultface from '../Apply/images/defaultface.png';
import IconBox from '../../components/IconBox';
import './index.less';
import { urls } from '../../config/web.config';
import '../Home/index.less';

@connect(
  state => ({ ...state.detail, ...state.home, ...state.global }),
  dispatch => bindActionCreators({ ...home, ...global, ...detail }, dispatch)
)
export default class Detail extends React.Component {
  state = {
    desc: '', 
    showDialog: false
  };

  componentWillMount() {
    const { 
      getFetchDetail, 
      _initClaimDetail 
    } = this.props;
    _initClaimDetail();
    // window.HWH5.loading({ status: true });
    window.HWH5.navTitle({ title: i18n.t('common:Request Detail') });
    // 获取申请人(自己)的登录信息
    const { match } = this.props;
    const { params = {} } = match;
    getFetchDetail(params.detailId);// 获取详情信息
    // window.HWH5.loading({ status: false });
  }

  handleApprove = async result => {
    const { 
      setApproval, history, match, restParam, approveAll, inapproval, approved, applyAll, applyPass,
      applyExamine, applyReject, setReload
    } = this.props; // myDetail
    const { params = {} } = match;
    const { desc } = this.state;
    if (desc === '') {
      window.HWH5.toast({ msg: i18n.t('common:Enter your comments'), type: 'n' });
    } else {
      const param = {
        approveState: result, 
        approveDesc: desc,
        id: params.detailId
      };
      const res = await setApproval(param);
      if (res && res.code === '0') {
        if (result === 2) {
          window.HWH5.toast({ msg: i18n.t('common:Approved successfully'), type: 'n' });
        }
        if (result === 3) {
          window.HWH5.toast({ msg: i18n.t('common:Rejected the request'), type: 'n' });
        }
        restParam(approveAll, 'approveAll');
        restParam(inapproval, 'inapproval');
        restParam(approved, 'approved');
        restParam(applyAll, 'applyAll');
        restParam(applyPass, 'applyPass');
        restParam(applyExamine, 'applyExamine');
        restParam(applyReject, 'applyReject');
        setReload(true);
        history.goBack();
      }
      if (res && res.code !== '0') {
        window.HWH5.toast({ msg: i18n.t('common:submitFail'), type: 'n' });
        console.log(res, '审批失败res');
      }
    }
  };

  // 判断是否为空
  isNotEmpty = (value) => {
    if (typeof value !== 'undefined' && value !== null && value !== '') {
      return true;
    }
    return false;
  }

  // 获取用户头像
  handleFaceImg = (userId, userName) => {
    if (this.isNotEmpty(userId) && this.isNotEmpty(userName)) {
      const headerPath = urls.headIcon.replace('{0}', userId);
      return headerPath;
    }
    return defaultface;
  }

  render() {
    const {
      claimDetail
    } = this.props; // myDetail
    const { showDialog, desc } = this.state;
    const { match } = this.props;
    const { params = {} } = match;
    return (
      <div className="App app_detail_bg">
        <Tab style={{ borderTop: '1px solid transparent' }}>
          <TabBody style={{ marginBottom: claimDetail.approveState === 0 && params.type !== '0' ? '35px' : '', paddingBottom: '0' }}>
            <Cells>
              <CellsTitle style={{ fontSize: '16px', color: '#333', marginBottom: '0px' }}>
                <div className="flex">
                  <div className="header" style={{ lineHeight: 1.5 }}>
                    {/* 物品用途 */}
                    {i18n.t('common:Purpose')}
                  </div>
                </div>
              </CellsTitle>
              <Form>
                <FormCell style={{ paddingTop: 0 }}>
                  <CellBody>
                    <div className="inputContent address-text color333" style={{ paddingLeft: '0', fontSize: '14px' }}>{claimDetail.goodsUse}</div>
                  </CellBody>
                </FormCell>
              </Form>
            </Cells>
            {/* 物品明细 */}
            {claimDetail.list && claimDetail.list.map((item, index) => (
              <div key={index}> 
                <div className="flex article">
                  <div className="header" style={{ lineHeight: 1.5 }}>
                    {i18n.t('common:Detail')}{'(' + (index + 1) + ')'}
                  </div>
                </div>
                <Cells>
                  <Cell className="commonCell time">
                    <CellBody className="header">
                      {/* 物品名称 */}
                      {i18n.t('common:GoodsName')}
                    </CellBody>
                    <div style={{ paddingRight: '10px', width: '65vw', textAlign: 'right' }}>
                      {item.goodsName}
                    </div>
                  </Cell>
                  <Cell className="commonCell time">
                    <CellBody className="header">
                      {/* 数量 */}
                      {i18n.t('common:Amount')}
                    </CellBody>
                    <div style={{ paddingRight: '10px', width: '65vw', textAlign: 'right' }}>
                      {item.amount}
                    </div>
                  </Cell>
                </Cells>
              </div>
            ))
            }
            
            {/* 领用说明 */}
            <Cells>
              <CellsTitle style={{ fontSize: '16px', color: '#333', marginBottom: '0px' }}>
                <div className="flex">
                  <div className="header" style={{ lineHeight: 1.5 }}>
                    {i18n.t('common:Purpose Detail')}
                  </div>
                </div>
              </CellsTitle>
              <Form>
                <FormCell style={{ paddingTop: 0 }}>
                  <CellBody>
                    <div className="inputContent address-text color333" style={{ paddingLeft: '0', fontSize: '14px' }}>
                      {claimDetail.instruction}
                    </div>
                  </CellBody>
                </FormCell>
              </Form>
            </Cells>
            {/* 审批人 */}  
            <Cells 
              className="detail__icon-box" 
              style={{ marginBottom: claimDetail.approveState === 2 ? '80px' : (claimDetail.approveState === 3 ? '0px' : ((claimDetail.approveState === 1 && params.type !== '0') ? '80px' : '80px')) }}
            >
              <Cell>
                <CellBody className="header">
                  {/* 审批人 */}
                  {i18n.t('common:Approvers')}
                </CellBody>
              </Cell>
              <Cell className="iconBox">
                <IconBox
                  clsName="box"
                  imgstr={(
                    <img
                      src={
                        this.handleFaceImg(
                          claimDetail.applyId.toLowerCase(), 
                          i18n.language === 'zh_CN' ? claimDetail.applyCnName : claimDetail.applyEnName
                        )
                      }
                      alt=""
                      onError={(e) => {
                        e.target.src = defaultface;
                      }}
                    />)}
                  title={i18n.language === 'zh_CN' ? claimDetail.applyCnName : claimDetail.applyEnName}
                />
                <IconBox clsName="splitImg" />
                <IconBox
                  clsName="box"
                  imgstr={(
                    <img
                      src={this.handleFaceImg(
                        claimDetail.approveId.toLowerCase(), 
                        i18n.language === 'zh_CN' ? claimDetail.approveCnName : claimDetail.approveEnName
                      )}
                      alt=""
                      onError={(e) => {
                        e.target.src = defaultface;
                      }}
                    />)}
                  title={i18n.language === 'zh_CN' ? claimDetail.approveCnName : claimDetail.approveEnName}
                />
              </Cell>
            </Cells>
            {
              claimDetail.approveState === 3 && (
                <Cells style={{ marginTop: '8px', marginBottom: '80px' }}>
                  <CellsTitle style={{ fontSize: '16px', color: '#333', marginBottom: '0px' }}>
                    <div className="flex">
                      <div className="header" style={{ lineHeight: 1.5 }}>
                        {i18n.t('common:goodsUse for Rejection')}
                      </div>
                    </div>
                  </CellsTitle>
                  <Form>
                    <FormCell style={{ paddingTop: 0 }}>
                      <CellBody>
                        <div className="inputContent" style={{ fontSize: '14px', wordBreak: 'break-word' }}>{claimDetail.approveDesc}</div>
                      </CellBody>
                    </FormCell>
                  </Form>
                </Cells>
              ) 
            }
          </TabBody>
          <TabBar>
            <TabBarItem>
              {claimDetail.approveState === 1 && params.type !== '0' && (
                <ButtonArea direction="horizontal">
                  <Button
                    style={{ borderRadius: 2, marginRight: '5px' }}
                    onClick={() =>this.setState({ desc: i18n.t('common:agree') }, () =>this.handleApprove(2))
                    }
                  >
                    {/* 通过Approve */}
                    {i18n.t('common:Approve')}
                  </Button>
                  <Button
                    style={{ borderRadius: 2, marginLeft: '5px' }}
                    type="warn" 
                    onClick={() => { this.setState({ showDialog: true, desc: '' }); }}
                  >
                    {/* 驳回 */}
                    {i18n.t('common:Reject')}
                  </Button>
                </ButtonArea>
              )} 
              {claimDetail.approveState === 2 && (
                <div>
                  <Button disabled>
                    {/* 已通过 */}
                    {i18n.t('common:Approved')}
                  </Button>
                </div> 
              )}
              {claimDetail.approveState === 3 && (
                <div>
                  <Button disabled>
                    {/* 已驳回 */}
                    {i18n.t('common:Rejected')}
                  </Button>
                </div> 
              )}
              {claimDetail.approveState === 1 && params.type === '0' && (
                <div>
                  <Button disabled>
                    {/* 审批中 */}
                    {i18n.t('common:Approving')}
                  </Button>
                </div>
              )}
            </TabBarItem>
          </TabBar>        
        </Tab>
        {/* 点击驳回后，会出现一个模态框提示填写驳回理由 */}
        <Dialog
          className="dismiss-dialog"
          title={i18n.t('common:Rejection of approval')}
          show={showDialog}
          buttons={[
            {
              type: 'default',
              label: i18n.t('common:Cancel'),
              onClick: () =>{ this.setState({ showDialog: false });document.activeElement.blur(); }
            },
            {
              type: 'default',
              label: i18n.t('common:OK'),
              onClick: () => this.handleApprove(3)
            }
          ]}
        >
          <Cells>
            <FormCell className="textareaWarp">
              <TextArea
                placeholder={i18n.t('common:Enter your comments')}
                rows="4"
                showCounter={false}
                maxLength="400"
                onChange={e => this.setState({ desc: e.target.value })}
                value={desc}
                style={{ lineHeight: '1.2' }}
              />
            </FormCell>
          </Cells>
        </Dialog>
      </div>
    );
  }
}

Detail.propTypes = {
  _initClaimDetail: PropTypes.func,
  getFetchDetail: PropTypes.func,
  claimDetail: PropTypes.object,
  setApproval: PropTypes.func,
  history: PropTypes.object,
  match: PropTypes.object // url参数
};
