/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 12:02:50
* @project : We码 物品领用
* @description : 首页，物品列表页面
*
* @last modified by : jiys
* @last modified time : 2018-12-12 12:02:50
*
*/

import React from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import ReactPullLoad, { STATS } from 'react-pullload'; // 上拉加载，下拉刷新插件
import PropTypes from 'prop-types';
import {
  NavBar, 
  TabBody, 
  NavBarItem, 
  DropDown,
  Button
} from '@wecode/react-weui';
import i18n from 'i18n';
import { 
  title, 
  load, 
  Application,
  Approval, 
  getClassName 
} from '../../utils/const.js';

import * as home from '../../actions/home';
import * as global from '../../actions/global';
import './pull.less';
import './index.less';
import ListBox from '../../components/ListBox';
import ExceptionTips from '../../components/ExceptionTip';

@connect(
  state => ({ ...state.home, ...state.global }),
  dispatch => bindActionCreators({ ...home, ...global }, dispatch)
)
export default class Home extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      action: STATS.init
    };
  }

  async componentWillMount() {
    title(i18n.t('common:Ride Request'));
    const { 
      getUserInfo, tab, value, approveValue, reload, index, setReload,
      getApproveList, getCarMyList, applyAll, approveAll, setTab
    } = this.props;
    await getUserInfo();
    // 判断是否从后台请求数据
    if (reload) {
      getApproveList(approveAll, approveValue).then(res => {
        console.log(res);
        load(false);
        if (res && res.length > 0 && approveAll.total > 0) {
          setTab(1);
        }
        getCarMyList(applyAll, value).then((res)=>{
          load(false);
          if (tab === 3) {
            setTab(0);
          }
        });
      });
      setReload(false);
    } else {
      if (index !== 0) {
        if (getClassName('list_box__hd')) {
          getClassName('list_box__hd')[index - 1].scrollIntoView();
        }
      }
    }
  }

  // 我的申请中，分类筛选
  changeValue = value => {
    const { 
      getCarMyList, setValue
    } = this.props;
    const objValue = this.handleApply(value);
    console.log(objValue);
    getCarMyList(objValue, value).then(res => {
      setValue(value);
      this.refs.carList.scrollIntoView();
      load(false);
    });
  };

  // 我的审批中，分类筛选
  changeApproveValue = approveValue => {
    const { 
      getApproveList, setAppValue 
    } = this.props;
    const objValue = this.approveObj(approveValue);
    getApproveList(objValue, approveValue).then(res => {
      setAppValue(approveValue);
      this.refs.approveList.scrollIntoView();
      load(false);
    });
  };

  // 查看申请的详情
  handleMyDetail(e) {
    const { 
      history, setIndex, tab, setTab 
    } = this.props; // setDetailid
    this._isMounted = false;
    setTab(tab);
    setIndex(e.index);
    load(true);
    history.push(`/detail/${tab}/${e.id}`);
  };

  // 判断状态名
  handleApply(value) {
    const { 
      applyAll, applyPass, applyExamine, applyReject
    } = this.props;
    switch (value) {
      case 0: {
        return applyAll;
      }
      case 1: {
        return applyExamine;
      }
      case 2: {
        return applyPass;
      }
      case 3: {
        return applyReject;
      }
      default:
        return false;
    }
  }

  // 加载更多
  handleAction(_action) {
    const { 
      action
    } = this.state;
    const { 
      getCarMyList, setPage, handleMore, restParam, value,
      applyAll, applyPass, applyExamine, applyReject 
    } = this.props;
    const objValue = this.handleApply(value);
    const strValue = Application(value);
    if (_action === action) {
      return;
    }
    if (_action === STATS.refreshing) { // 刷新
      if (action === STATS.refreshing) {
        return;
      }
      this.setState({ action: STATS.refreshing });
      // 下拉刷新
      restParam(applyAll, 'applyAll');
      restParam(applyPass, 'applyPass');
      restParam(applyExamine, 'applyExamine');
      restParam(applyReject, 'applyReject');

      getCarMyList(objValue, value).then(res => {
        window.HWH5.loading({ status: false });
        console.log(res, '刷新');
        this.setState({ 
          action: STATS.refreshed
        });
        setTimeout(()=>{ this.setState({ action: STATS.reset }); }, 100);
      });
    } else if (_action === STATS.loading) { // 加载更多
      if (objValue.list.length < 10) {
        handleMore(objValue, false, strValue);
      }
      if (!objValue.hasMore) { // 中英文语言设置
        if (getClassName('pull-load-footer-default')[0]) {
          setTimeout(() => {
            getClassName('pull-load-footer-default')[0].innerHTML = i18n.t('common:No more');
          }, 100);
        }
        return;
      }
      this.setState({ action: STATS.loading });
      setPage(objValue, (objValue.page + 1), strValue);
      getCarMyList(objValue, value, true).then(res => {
        window.HWH5.loading({ status: false });
        if (res.length < 10) {
          handleMore(objValue, false, strValue);
        }
        this.setState({ action: STATS.reset });
      });

    } else {
      this.setState({
        'action': _action
      });
    }
  }

  // 判断审批状态名
  approveObj(value) {
    const { 
      approveAll, inapproval, approved
    } = this.props;
    switch (value) {
      case 0: {
        return approveAll;
      }
      case 1: {
        return inapproval;
      }
      case 4: {
        return approved;
      }
      default:
        return false;
    }
  }

  // 我的审批列表 状态改变处理
  handleMyAction(_action) {
    const { 
      action
    } = this.state;
    const { 
      getApproveList, setPage, handleMore, approveAll, 
      inapproval, approved, restParam, approveValue
    } = this.props;
    const objValue = this.approveObj(approveValue);
    const strValue = Approval(approveValue);
    if (_action === action) {
      return;
    }
    if (_action === STATS.refreshing) { // 刷新
      if (action === STATS.refreshing) {
        return;
      }
      this.setState({ action: STATS.refreshing });
      // 下拉刷新{
      restParam(approveAll, 'approveAll');
      restParam(inapproval, 'inapproval');
      restParam(approved, 'approved');

      getApproveList(objValue, approveValue).then(res => {
        window.HWH5.loading({ status: false });
        this.setState({ 
          action: STATS.refreshed
        });
        setTimeout(()=>{
          this.setState({ action: STATS.reset });
        }, 100);
      });
    } else if (_action === STATS.loading) { // 加载更多
      if (objValue.list.length < 10) {
        handleMore(objValue, false, strValue);
      }
      if (!objValue.hasMore) {
        if (getClassName('pull-load-footer-default')[0]) {
          setTimeout(() => {
            getClassName('pull-load-footer-default')[0].innerHTML = i18n.t('common:No more');
          }, 100);
        }
        return;
      }
      this.setState({ action: STATS.loading });
      setPage(objValue, (objValue.page + 1), strValue);
      getApproveList(objValue, approveValue, true).then(res => {
        window.HWH5.loading({ status: false });
        if (res.length < 10) {
          handleMore(objValue, false, strValue);
        }
        this.setState({ action: STATS.reset });
      });
    } else {
      this.setState({
        'action': _action
      });
    }
  }

  render() {
    const dataList = [
      { value: 0, label: i18n.t('common:All') },
      { value: 2, label: i18n.t('common:Approved') },
      { value: 1, label: i18n.t('common:Approving') },
      { value: 3, label: i18n.t('common:Rejected') }
    ];
    const approveDataList = [
      { value: 0, label: i18n.t('common:All') },
      { value: 4, label: i18n.t('common:Processed') },
      { value: 1, label: i18n.t('common:Approving') }
    ];
    const { 
      myApplyList = [], myApproveList = [], userInfo = {}, hasMore, inApproveTotal, tab,
      value, approveValue, setTab
    } = this.props;
    const {
      action
    } = this.state;
    return (
      <div className="Home">
        <NavBar className="app-tab__font" style={{ height: '7vh', lineHeight: '7vh' }}>
          <NavBarItem
            style={{ height: '7vh', lineHeight: '7vh' }}
            active={tab === 0}
            onClick={e => setTab(0)}
          >
            <span
              className={
                tab === 0
                  ? 'app-tab__font_active_on'
                  : 'app-tab__font_active_off'
              }
            >
              {i18n.t('common:My Requests')}
              {/* 我的申请 */}
            </span>
          </NavBarItem>
          <NavBarItem
            style={{ height: '7vh', lineHeight: '7vh' }}
            active={tab === 1}
            onClick={e => setTab(1)}
          >
            <span
              className={
                tab === 1
                  ? 'app-tab__font_active_on'
                  : 'app-tab__font_active_off'
              }
            >
              {/* 我的审批 */}
              {`${i18n.t('common:My Approvals')}`}({inApproveTotal > 0 ? inApproveTotal : '0'})
            </span>
          </NavBarItem>
        </NavBar>
        <TabBody style={{ height: '100vh', backgroundColor: '#f5f5f5' }}>
          <div
            style={{
              width: '100%',
              position: 'absolute',
              zIndex: '10000',
              display: tab === 0 ? null : 'none'
            }}
          >
            <DropDown
              key="dropdown"
              value={value}
              radioName="radio"
              dataSource={dataList}
              onChange={value => this.changeValue(value)}
            />
          </div>
          <div
            style={{
              width: '100%',
              position: 'absolute',
              zIndex: '10000',
              display: tab === 1 ? null : 'none'
            }}
          >
            <DropDown
              key="dropdown"
              value={approveValue}
              radioName="radio"
              dataSource={approveDataList}
              onChange={value => this.changeApproveValue(value)}
            />
          </div>
          {tab === 0 && (
            <ReactPullLoad
              className="block applyList"
              isBlockContainer={!false}
              downEnough={100}
              action={action}
              handleAction={this.handleAction.bind(this)}
              hasMore={hasMore}
              distanceBottom={100}
            >
              <div ref="carList" style={{ paddingTop: '80px' }}>
                <ListBox
                  key="1"
                  data={myApplyList}
                  onClick={e => this.handleMyDetail(e)}
                  userInfo={userInfo}
                />                
                { (!myApplyList || myApplyList.length === 0) && (
                  <ExceptionTips heightFrom="7vh" />
                )}
              </div>
            </ReactPullLoad>   
          )}
          {tab === 1 && (
            <ReactPullLoad
              className="block approveList"
              isBlockContainer={!false}
              downEnough={100}
              action={action}
              handleAction={this.handleMyAction.bind(this)}
              hasMore={hasMore}
              distanceBottom={100}
            >
              <div ref="approveList" style={{ paddingTop: '80px' }}>
                <ListBox
                  key="2"
                  data={myApproveList}
                  onClick={e => this.handleMyDetail(e)}
                  userInfo={userInfo}
                />
                { (!myApproveList || myApproveList.length === 0) && (
                  <ExceptionTips heightFrom="7vh" />
                )}
              </div>
            </ReactPullLoad>
          )}

        </TabBody>
        {tab === 0 && (
          <div className="addBtn" style={{ zIndex: '9999' }}>
            <Link to="/apply" style={{ width: '100%', display: 'inline-block' }}>
              <Button>
                {/* 新建 */}
                {i18n.t('common:New request')}
              </Button>
            </Link>
          </div>
        )}
      </div>
    );
  }
}

Home.propTypes = {
  userInfo: PropTypes.object,
  myApplyList: PropTypes.array,
  myApproveList: PropTypes.array,
  getUserInfo: PropTypes.func,
  getCarMyList: PropTypes.func,
  getApproveList: PropTypes.func,
  setPage: PropTypes.func,
  hasMore: PropTypes.bool,
  handleMore: PropTypes.func,
  setReload: PropTypes.func,
  reload: PropTypes.bool,
  index: PropTypes.number,
  setIndex: PropTypes.func,
  history: PropTypes.object,
  tab: PropTypes.number,
  value: PropTypes.number,
  approveValue: PropTypes.number,
  setAppValue: PropTypes.func,
  setValue: PropTypes.func,
  setTab: PropTypes.func,
  applyAll: PropTypes.object,
  applyExamine: PropTypes.object,
  applyPass: PropTypes.object,
  applyReject: PropTypes.object,
  approveAll: PropTypes.object,
  inapproval: PropTypes.object,
  approved: PropTypes.object,
  restParam: PropTypes.func,
  inApproveTotal: PropTypes.number
};
