/**
 * 路由配置文件
 * 如果需要按需加载，可使用asyncComponent加载，用法请参考README.md文件
*/

import { AsyncComponent } from '@wecode/wlk-react-template-util';
import Home from './Home';
// import Detail from './Detail';

// webpackChunkName 可指定模块名称，访问路由按需加载
const routes = [
  { path: '/', component: Home, exact: true },
  { path: '/apply', component: AsyncComponent(() => import('./Apply')), exact: true },
  { path: '/detail/:type/:detailId', component: AsyncComponent(() => import('./Detail')), exact: true }
  // { path: '/detail/:type/:detailId', component: Detail, exact: true }
];

export default routes;
