/**
*
* 华为软件技术有限公司，版权所有 违者必究 copyright 2012-2019
*
* @author : liy
* @date : 2018-12-12 11:01:07
* @project : We码 物品领用
* @description : App 公共常量、方法
*
* @last modified by : jiys
* @last modified time : 2018-12-12 11:01:07
*
*/

/**
* app 顶部提示
* @param {String} message 提示文字
*/
export function toast(message) {
  return window.HWH5.toast({ msg: message, time: 1000 });
};  

/**
* app title 修改
* @param {String} message 标题文字
*/
export function title(message) {
  return window.HWH5.navTitle({ title: message });
};

/**
* app 加载提示框
* @param {Boolean} bool
*/
export function load(bool) {
  return window.HWH5.loading({ status: bool });
};

/**
* 判断申请状态名
* @param {Int} value 状态值
* @return {String}
*/
export function Application(value) {
  switch (value) {
    case 0: {
      return 'applyAll';
    }
    case 1: {
      return 'applyExamine';
    }
    case 2: {
      return 'applyPass';
    }
    case 3: {
      return 'applyReject';
    }
    default:
      return false;
  }
};

/**
* 判断审批状态名
* @param {Int} value 状态值
* @return {String}
*/
export function Approval(value) {
  switch (value) {
    case 0: {
      return 'approveAll';
    }
    case 1: {
      return 'inapproval';
    }
    case 4: {
      return 'approved';
    }
    default:
      return false;
  }
}

/**
* 通过class获取dom
* @param {String} name class名
*/
export function getClassName(name) {
  return document.getElementsByClassName(name);
}

/**
* 截取目标字符串、数组，限制最大长度为5
* @param {String|Array} value 字符串|数组
* @return {*} value
*/
export function maxLengthFive(value) {
  if (value.length > 5) {
    value = value.slice(0, 5); 
    return value;
  } else {
    return value;
  }
}
