# -*- coding: UTF-8 -*-
from flask import Flask
from config import configs
# from flask_bootstrap import Bootstrap

# 需要界面，开启bootstrap框架
# bootstrap = Bootstrap()


def create_app(config_name):
    app = Flask(__name__)
    app.config.from_object(configs[config_name])
    configs[config_name].init_app(app)
    # bootstrap.init_app(app)

    from .api import api as api_blueprint
    app.register_blueprint(api_blueprint, url_prefix="/api/v1/")

    return app