# -*- coding: UTF-8 -*-
from flask import request, current_app, jsonify
from . import api
from app.utility.welink import WeLink


@api.route('/')
def hello_world():
    return 'Hello, World!'


@api.route('/userid')
def user_id():
    code = request.args.get('code', None)
    if code is None:
        return "code is missing!"
    welink = WeLink(current_app.config['API_URL'],
                    current_app.config["CLIENT_ID"],
                    current_app.config["CLIENT_SECRET"])
    res = welink.make_request("get", "auth/v2/userid?code=".format(code))
    return jsonify(res)








