# -*- coding: UTF-8 -*-
import requests
import json

ERROR_METHOD = "method is not support!"


class WeLink(object):
    __token = None

    def __init__(self, api_url, client_id, client_secret):
        self.api_url = api_url
        self.client_id = client_id
        self.client_secret = client_secret
        if self.__class__.__token is None:
            self.token = self.__access_token()

    def __make_url(self, path):
        return "{}://{}/{}".format("https", self.api_url, path)

    def __make_header(self, is_auth=False):
        # 如果是认证场景
        if is_auth:
            headers = {"x-wlk-Authorization": self.__class__.__token}
        else:
            headers = {"Content-type": "application/json"}
        return headers

    # todo 异常状态，容错处理

    def __access_token(self):
        header = self.__make_header()
        payload = json.dumps({"client_id": self.client_id,
                              "client_secret": self.client_secret})
        res = self.make_request("post",
                                path=self.__make_url("auth/v2/tickets"),
                                data=payload,
                                headers=header)
        access_token = res.get("access_token")
        return access_token

    def make_request(self, methods, path, data=None, headers=None):
        if 'post' == methods.lower():
            payload = json.dumps(data)
            response = requests.post(url=self.__make_url(path),
                                     headers=headers,
                                     data=payload)
            res = response.json()
        elif 'get' == methods.lower():
            if headers is None:
                headers = self.__make_header(is_auth=True)
            response = requests.get(url=self.__make_url(path),
                                    headers=headers)
            res = response.json()
        else:
            res = self.__make_error_response("-1", ERROR_METHOD)
        return res

    @staticmethod
    def __make_error_response(code, message):
        response = {"code": code,
                    "message": message}
        return json.dumps(response)

