# -*- coding: UTF-8 -*-
import os

# 获取环境变量
APP_ENV = os.environ.get('WeLink_DEFAULT_CONFIG') or 'production'


class Config:
    def init_app(app):
        pass


class DevelopmentConfig(Config):
    DEBUG = True
    SECRET_KEY = 'WeLink is good'
    API_URL = 'open.welink.digitalworkplace.cn/api'
    # UAT环境应用id
    CLIENT_ID = ''
    # UAT环境应用密钥
    CLIENT_SECRET = ''


class ProductionConfig(Config):
    DEBUG = False
    SECRET_KEY = 'WeLink is good too'
    API_URL = 'open.welink.huaweicloud.com/api'
    # 生产环境应用id
    CLIENT_ID = ''
    # 生产环境应用secret
    CLIENT_SECRET = ''


class TestingConfig(Config):
    pass


configs = {
    'development': DevelopmentConfig,
    'production': ProductionConfig,
    'testing': TestingConfig,
    'default': DevelopmentConfig
}
